---
title: The Perfect Alt-text
slug: the-perfect-alt-text
date: 2019-08-14
categories: html, accessibility
---

# The Perfect Alt-text
<p class='timestamp'><time datetime='14-08-2019'>14-08-2019</time></p>
<hr>

Writing proper and thorough alternative text (alt-text) for images on the web, 
is not just important. It is vital for those who depend on screen readers for 
navigating the web.

In spite of this, many publishers continue to include useless text 
or neglect the alt-text entirely.

## So, how do you do it?
Writing proper alt-text is, at its core, very simple. All you need to do, 
is describe the image. E.g.: “Group of people on a train station.”.

A few things to avoid would be: 
- Including the name of the photographer
- Adding keywords for search engine optimization.
- Saying "Image of" or "Photo of".

<a href="https://axesslab.com/alt-texts/" target="_blank" rel="noopener" title="Article: Alt-texts: The Ultimate Guide">
Daniel Göransson published a wonderful article on the subject back in October 2017.
</a>
