<?php

/**********************************************************************
 *                                                                    *
 *                    CODENAME: STEGOSAURUS                           *
 *           Stegusaurus Static Site Compiler (SSSC) v.0.1            *
 *                                                                    *
 *               AUTHORS: Tristan White & Daniel Bahl                 *
 *                                                                    *
 *********************************************************************

  _____
 /     \
|       |
 \     /
  `-=-'
     `@`

*/

// Initialize the Stegusaurus
require(__DIR__ . '/_steguinit.php');

Console::log('Velkommen til STEGOSAURUS', 'white', 'green');
Console::log('                         
_____ _____ _____ _____ 
|   __|   __|   __|     |
|__   |__   |__   |   --|
|_____|_____|_____|_____|
Stegusaurus Static Site Compiler (SSSC) v.0.1 
 ', 'green', 'white');


// Load all posts from the _posts folder
$dir = new DirectoryIterator(__DIR__.'/_posts');
$dirSorted = array();
foreach ($dir as $fileinfo) {
    if (!$fileinfo->isDot() && $fileinfo->getExtension() === 'md') {
        $markdown = file_get_contents(__DIR__.'/_posts/'.$fileinfo->getFilename());
        $result = $converter->convert($markdown);
        $fmParsed = $result->getFrontMatter();
        $dirSorted[] = array(
            'filename' => __DIR__.'/_posts/'.$fileinfo->getFilename(),
            'title' => $fmParsed['title'],
            'dateUnixTimestamp' => $fmParsed['date'],
            'dateParsedTimestamp' => date("Y-m-d", $fmParsed['date'])
        );
    }
}

// Load all posts from the _posts folder
$dirPages = new DirectoryIterator(__DIR__.'/_pages');
$dirPagesSorted = array();
foreach ($dirPages as $fileinfo) {
    if (!$fileinfo->isDot() && $fileinfo->getExtension() === 'md') {
        $markdown = file_get_contents(__DIR__.'/_pages/'.$fileinfo->getFilename());
        $result = $converter->convert($markdown);
        $fmParsed = $result->getFrontMatter();
        $dirPagesSorted[] = array(
            'filename' => __DIR__.'/_pages/'.$fileinfo->getFilename(),
            'title' => $fmParsed['title']
        );
    }
}

// Sort the array with posts by dateUnixTimestamp
usort($dirSorted, function($a, $b) {
    return $b['dateUnixTimestamp'] <=> $a['dateUnixTimestamp'];
});
usort($dirPagesSorted, function($a, $b) {
    return $b['dateUnixTimestamp'] <=> $a['dateUnixTimestamp'];
});

// Remote old stuff
exec('rm -rf '.__DIR__.'/html/*');

// Json for RSS and Sitemap:
$siteIndex = array();
$draftIndex = array();
$tagIndex = array();

foreach($dirSorted as $p) {

    //echo "🦖 Parsing: " . $p['title'] . "\n";
    $markdown = file_get_contents($p['filename']);
    // parse markdown
    $result = $converter->convert($markdown);
    $blogFrontMatter = $result->getFrontMatter(); 
    $blogContent = $result->getContent();

    // if no slug? make one!
    if(!isset($blogFrontMatter['slug'])||empty($blogFrontMatter['slug'])) {
        $blogFrontMatter['slug'] = $stegusaurus->steguSlug($p['title']);
    }

    // no layout defined, fallback to "post":
    $p['layout'] = (!empty($blogFrontMatter['layout'])) ? $blogFrontMatter['layout'] : "post";
    $p['title'] = (!empty($blogFrontMatter['title'])) ? $blogFrontMatter['title'] : $blogFrontMatter['filename'];
    $blogFrontMatter['description'] = (!empty($blogFrontMatter['description'])) ? $blogFrontMatter['description'] : $blogFrontMatter['title'];

    // does file exist?
    if(!file_exists(__DIR__ . '/_layouts/'. $p['layout'] . ".html")) {
        $p['layout'] = "post";
    }

    // Frontend variables (everything here is available with %%var%%)
    $frontendVariables = array(
        'title' => $blogFrontMatter['title'],
        'description' => $blogFrontMatter['description'],
        'content' => $blogContent,
        'year' => date("Y")
    );

   
    
    // Do some magic
    $blogContentParsed = $stegusaurus->includeFiles(__DIR__ . '/_layouts/'. $p['layout'] . ".html");
    $blogContentParsed = $stegusaurus->includeVars($blogContentParsed, $frontendVariables);

    if(isset($blogFrontMatter['draft']) && $blogFrontMatter['draft'] == "true") {

        $dirPublish = __DIR__ . "/html/draft-" . strtolower($blogFrontMatter['slug']) . "/";
        if (!file_exists($dirPublish)) {
            mkdir($dirPublish, 0777, true);
        }
        file_put_contents($dirPublish."index.html", $blogContentParsed);
        $draftIndex[] = array(
            'title' => $blogFrontMatter['title'],
            'description' => $blogFrontMatter['description'],
            'url' => strtolower("draft-".$blogFrontMatter['slug']),
            'uri' =>  $domain . "draft-" . strtolower($blogFrontMatter['slug'])."/"
        );

    } else {

         // Tags
        if(isset($blogFrontMatter['tags']) && !empty($blogFrontMatter['tags'])) {
            foreach($blogFrontMatter['tags'] as $tag) {

                
                    $tagIndex[$tag][] = array(
                        'tag' => $tag,
                        'title' => $blogFrontMatter['title'],
                        'description' => $blogFrontMatter['description'],
                        'url' => strtolower($blogFrontMatter['slug']),
                        'uri' =>  $domain . strtolower($blogFrontMatter['slug'])."/"
                    );
               

            }
        }
    

        $dirPublish = __DIR__ . "/html/" . strtolower($blogFrontMatter['slug']) . "/";
        if (!file_exists($dirPublish)) {
            mkdir($dirPublish, 0777, true);
        }
        file_put_contents($dirPublish."index.html", $blogContentParsed);
        $siteIndex[] = array(
            'title' => $blogFrontMatter['title'],
            'description' => $blogFrontMatter['description'],
            'url' => strtolower($blogFrontMatter['slug']),
            'uri' => $domain.strtolower($blogFrontMatter['slug']).'/',
        );

    }

}

// articles.html page
$totalRecords = count($siteIndex);
$totalPages   = ceil($totalRecords / $pageSize);

for($i = 0; $i < $totalPages; $i++) {
    // Extract a portion of $siteIndex array
    $page_data = array_slice($siteIndex, $i*$pageSize, $pageSize);

    $articles = "<!-- Page Content START -->";
    foreach($page_data as $item) {
        $articles .= "<h1>" . $item['title'] . "</h1>\n";
        $articles .= "<p>" . $item['description'] . "</p>\n";
        $articles .= "<a href='" . $item['url'] . "'>Read More</a>\n";
    }
  
         // Generate pagination
    $articles .= "<!-- Pagination START -->";
    $articles .= "<nav class='pagination' aria-label='Pagination'>\n";
    $articles .= "<ul>\n";

    // Previous link
    if ($i > 0) {
        $articles .= "<li><a href='" .$pageName. $i . ".html' aria-label='Prev Page'>← Prev</a></li> ";
    }
    
    // Add a 'First page' link if the first page isn't visible
    if ($i - $displayPages > 0) {
        $articles .= "<li><a href='".$pageName."1.html' aria-label='Page 1'>1</a></li> ";
        if ($i - $displayPages > 1) {
            $articles .= "<li><span>...</span></li> ";
        }
    }

    for($j = 0; $j < $totalPages; $j++) {
        if(abs($j - $i) <= $displayPages) { // Show pages near current, first and last page
            if($j == $i) {
                // Current page, so don't make it a link
                $articles .= "<li><a href='". $pageName . ($j+1) . ".html' aria-label='Page " . ($j+1) . "' aria-current='page'>" . ($j+1) . "</a></li> ";
            } else {
                // Not the current page, so make it a link
                $articles .= "<li><a href='" .$pageName . ($j+1) . ".html' aria-label='Page " . ($j+1) . "'>" . ($j+1) . "</a></li> ";
            }
        }
    }

    // Add a '...' and the last page number if the last page isn't visible
    if ($i + $displayPages < $totalPages - 2) {
        $articles .= "<li><span>...</span></li> ";
    }
    if ($i + $displayPages < $totalPages - 1) {
        $articles .= "<li><a href='" . $pageName .$totalPages . ".html' aria-label='Page " . $totalPages . "'>" . $totalPages . "</a></li> ";
    }

    // Next link
    if ($i < $totalPages - 1) {
        $articles .= "<li><a href='" .$pageName . ($i + 2) . ".html' aria-label='Next Page'>Next →</a></li> ";
    }

    $articles .= "</ul>\n";
    $articles .= "</nav>\n";

    $frontendVariables = array(
        'title' => "Alle indlæg - Side " . ($i+1),
        'description' => "Alle indlæg",
        'content' => $articles,
        'year' => date("Y")
    );
    
    // Do some magic
    $blogContentParsed = $stegusaurus->includeFiles(__DIR__ . '/_layouts/' . $articlesLayout.".html");
    $blogContentParsed = $stegusaurus->includeVars($blogContentParsed, $frontendVariables);
    $dirPublish = __DIR__ . "/html/";
    if (!file_exists($dirPublish)) {
        mkdir($dirPublish, 0777, true);
    }
    file_put_contents($dirPublish. $pageName . ($i+1) . ".html", $blogContentParsed);
    
}


// Parse Tags
foreach($tagIndex as $tagIndexTitle => $tagIndexParse) {

    $tagIndexParsedContent = "<ul>";
    foreach($tagIndexParse as $tagIndexParsed) {

        $tagIndexParsedContent .= '<li><a href="/'.$tagIndexParsed['url'] . '/">' . $tagIndexParsed['title'] . '</a></li>';

    }
    $tagIndexParsedContent .= "</ul>";

    $frontendVariables = array(
        'title' => "Artikler tagget med " . $tagIndexTitle,
        'description' => "Artikler tagget med " . $tagIndexTitle,
        'content' => $tagIndexParsedContent,
        'year' => date("Y")
    );

    // Do some magic
    $blogContentParsed = $stegusaurus->includeFiles(__DIR__ . '/_layouts/' . $tagLayout.".html");
    $blogContentParsed = $stegusaurus->includeVars($blogContentParsed, $frontendVariables);
    $dirPublish = __DIR__ . "/html/" . strtolower($tagIndexTitle) . "/";
    if (!file_exists($dirPublish)) {
        mkdir($dirPublish, 0777, true);
    }
    file_put_contents($dirPublish."index.html", $blogContentParsed);
    $siteIndex[] = array(
        'title' => $blogFrontMatter['title'],
        'description' => $blogFrontMatter['description'],
        'url' => strtolower($blogFrontMatter['slug']),
        'uri' => $domain.strtolower($blogFrontMatter['slug']).'/',
    );
   
    
}



// PAGES
foreach($dirPagesSorted as $p) {

    $markdown = file_get_contents($p['filename']);
    // parse markdown
    $result = $converter->convert($markdown);
    $blogFrontMatter = $result->getFrontMatter(); 
    $blogContent = $result->getContent();

    // if no slug? make one!
    if(!isset($blogFrontMatter['slug'])||empty($blogFrontMatter['slug'])) {
        $blogFrontMatter['slug'] = $stegusaurus->steguSlug($p['title']);
    }

    // no layout defined, fallback to "post":
    $p['layout'] = (!empty($blogFrontMatter['layout'])) ? $blogFrontMatter['layout'] : "post";
    $p['title'] = (!empty($blogFrontMatter['title'])) ? $blogFrontMatter['title'] : $blogFrontMatter['filename'];
    $blogFrontMatter['description'] = (!empty($blogFrontMatter['description'])) ? $blogFrontMatter['description'] : $blogFrontMatter['title'];

    // does file exist?
    if(!file_exists(__DIR__ . '/_layouts/'. $p['layout'] . ".html")) {
        $p['layout'] = $defaultLayout;
    }

    // Frontend variables (everything here is available with %%var%%)
    $frontendVariables = array(
        'title' => $blogFrontMatter['title'],
        'description' => $blogFrontMatter['description'],
        'year' => date("Y")
    );
    
    // Do some magic
    $blogContentParsed = $stegusaurus->includeFiles(__DIR__ . '/_layouts/'. $p['layout'] . ".html");
    $blogContentParsed = $stegusaurus->includeVars($blogContentParsed, $frontendVariables);
    $dirPublish = __DIR__ . "/html/" . strtolower($blogFrontMatter['slug']) . "/";
    if (!file_exists($dirPublish)) {
        mkdir($dirPublish, 0777, true);
    }
    file_put_contents($dirPublish."index.html", $blogContentParsed);
    $siteIndex[] = array(
        'title' => $blogFrontMatter['title'],
        'description' => $blogFrontMatter['description'],
        'url' => strtolower($blogFrontMatter['slug']),
        'uri' => $domain.strtolower($blogFrontMatter['slug']).'/',
    );
}

// Include Sitemap Module:
include("_steguSitemap.php");

Console::log("Jeg er en success og har deployed ".count($siteIndex)." sider og  ".count($draftIndex)." draft blogindlæg", 'white', 'green');


if(count($draftIndex) > 0) {

    Console::log("Her er en oversigt over kladder", 'blue');
    Console::log("Drafts:","black");
    foreach($draftIndex as $dI) {
        Console::log( " [DRAFT] 🧃 ". $dI['title'] ." => " . $dI['uri'], 'white');
    }
}

Console::log( "🌍 Visit online: https://stegusaurus.vs.girafpingvin.dk/html/ ✅", "green");